unit Sensor01;
// ====================================================================
(*
       
      ().
           
       (TPanel)   (TForm1).
   // -----------------------------------------------------
   //     :
   //    XBeg          X -   Image
   //    YBeg          Y -   Image
   //    Title          
   //    Min            
   //    Max            
   //    Indx              
   // -----------------------------------------------------
   //   :
   Sensor := TSensor.Create( Panel1,   //      
                             XB, YB);  // Left  Top  
   // -----------------------------------------------------
   //       :
   if Assigned(Sensor)
   then ...... := Sensor.Value;       //   
   // -----------------------------------------------------
    1.01. ()  , , , , 2017.
                () Source code  ..
     29.12.2017
*)
// ====================================================================
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls;

// ================================================================
//      ()
type TSensor = class(TObject)
private
  // ---------------
  fPanel     : TPanel;       //    
  // ---------------
  fLbIndx    : TLabel;       //   
  fLbTitle   : TLabel;       //   
  fSTxtIndx  : TStaticText;  //  
  fEdTitle   : TEdit;        //  
  // ---------------
  fLbMin     : TLabel;       //    
  fLbValue   : TLabel;       //    
  fLbMax     : TLabel;       //    
  fEdMin     : TEdit;        //   
  fSTxtValue : TStaticText;  //   
  fEdMax     : TEdit;        //   
  // ---------------
  fTrackBar : TTrackBar;     //   
  // ---------------
  fChBoxNPr : TCheckBox;     //   
  fEdNPr    : TEdit;         //   
  // ---------------
  //    
  procedure EdMinChange(Sender: TObject);
  procedure EdMaxChange(Sender: TObject);
  procedure TrackBarChange(Sender: TObject);
  // ---------------------
  //  
  // ---------------------
  procedure SetIndx(Indx : integer);
  function  GetIndx() : integer;
   // ---------------------
  procedure SetTitle(Title : string);
  function  GetTitle() : string;
  // ---------------------
  procedure SetMin(Min : integer);
  function  GetMin() : integer;
  // ---------------------
  procedure SetMax(Max : integer);
  function  GetMax() : integer;
   // ---------------------
  function  GetValue() : integer;

public
   constructor Create(RqWinControl : TWinControl; XB,YB : integer);
   procedure Free;
   property Indx  : integer read GetIndx  write SetIndx;
   property Title : string  read GetTitle write SetTitle;
   property Min   : integer read GetMin   write SetMin;
   property Max   : integer read GetMax   write SetMax;
   property Value : integer read GetValue;
end;

// ================================================================
// ================================================================

implementation

// ================================================================
// ================================================================

// ================================================================
//     
// ================================================================
// ----------------------------------------------------------------
//  RqEdit.Text     
function TryEditToInt(RqEdit : TEdit; var Value : integer) : boolean;
begin
   Result := False;
   try
       if Trim(RqEdit.Text) = ''
       then Value := 0
       else begin
           Value := StrToInt(Trim(RqEdit.Text));
           RqEdit.Color := clWindow;
       end;
       Result := True;
   except
       RqEdit.Color := RGB(255,240,240);
       ShowMessage('       ');
   end;
end;

// ----------------------------------------------------------------
//   ,   TControl.
//  CreateControl    class () 
// ,      RqOwner
// (,  Form1).

function CreateControl(ControlClass  : TControlClass;
                       RqOwner       : TWinControl;
                 const ComponentName : string;
                      X, Y, W, H     : Integer): TControl;
begin
    Result := ControlClass.Create(RqOwner);
    with Result do
    begin
      Parent := RqOwner;               //    
      Name := ComponentName;           //   
      SetBounds(X, Y, W, H);           //   TWinControl
      Visible := True;                 //   
    end;
end;

// ================================================================
//    / 
// ================================================================
// ----------------------------------------------------------------
//   
constructor TSensor.Create(
          RqWinControl : TWinControl;  //      
          XB, YB : integer);           // Left  Top  
begin
   inherited Create;
   // ----------------------------------------------
   //      
   fPanel:= TPanel(CreateControl(TPanel, RqWinControl, '',
                   XB,YB,240,132));
   // ----------------------------------------------
   //       
   // ----------------------------------------------
   //  
   fLbIndx := TLabel(CreateControl(TLabel, fPanel, '',
                       12,6,40,16));
   fLbIndx.AutoSize := False;
   fLbIndx.Caption  := '';
   fSTxtIndx := TStaticText(CreateControl(TStaticText, fPanel, '',
                       12, 22, 40, 17));
   fSTxtIndx.Alignment   := taCenter;
   fSTxtIndx.AutoSize    := False;
   fSTxtIndx.BorderStyle := sbsSunken;
   fSTxtIndx.Font.Style  := [fsBold];
   // ----------------------------------------------
   //  
   fLbTitle := TLabel(CreateControl(TLabel, fPanel, '',
                       56,6,170,16));
   fLbTitle.AutoSize := False;
   fLbTitle.Caption  := ' ';
   fEdTitle := TEdit(CreateControl(TEdit, fPanel, '',
                       56, 22, 170, 18));
   fEdTitle.AutoSize := False;
   // ----------------------------------------------
   //  
   fEdMin  := TEdit(CreateControl(TEdit, fPanel, '',
                       12,58,66,18));
   fEdMin.AutoSize := False;
   fEdMin.Text := '-10';
   fEdMin.OnChange := EdMinChange;
   fLbMin := TLabel(CreateControl(TLabel, fPanel, '',
                       12,42,66,16));
   fLbMin.AutoSize := False;
   fLbMin.Caption := 'Min';
   // ----------------------------------------------
   //  
   fSTxtValue := TStaticText(CreateControl(TStaticText, fPanel, '',
                        84,58,66,18));
   fSTxtValue.Alignment   := taCenter;
   fSTxtValue.AutoSize    := False;
   fSTxtValue.BorderStyle := sbsSunken;
   fSTxtValue.Font.Style  := [fsBold];
   fSTxtValue.Caption := '0';
   fLbValue := TLabel(CreateControl(TLabel, fPanel, '',
                       84,42,66,16));
   fLbValue.AutoSize := False;
   fLbValue.Caption  := 'Value';
   // ----------------------------------------------
   //  
   fEdMax := TEdit(CreateControl(TEdit, fPanel, '',
                       156,58,66,18));
   fEdMax.AutoSize := False;
   fEdMax.Text := '10';
   fEdMax.OnChange := EdMaxChange;
   fLbMax := TLabel(CreateControl(TLabel, fPanel, '',
                       156,42,66,16));
   fLbMax.AutoSize := False;
   fLbMax.Caption  := 'Max';
   // ----------------------------------------------
   //  
   fTrackBar := TTrackBar(CreateControl(TTrackBar, fPanel, '',
                           4, 82, 230, 22));
   fTrackBar.TickStyle := tsNone;
   fTrackBar.ThumbLength := 16;
   fTrackBar.TickMarks := tmTopLeft;
   fTrackBar.Min := -10;
   fTrackBar.Max :=  10;
   fTrackBar.Position := 0;
   fTrackBar.OnChange := TrackBarChange;
   // ----------------------------------------------
   //   
   fChBoxNPr := TCheckBox(CreateControl(TCheckBox, fPanel, '',
                           12, 106, 170, 20));
   fChBoxNPr.Checked := True;
   fChBoxNPr.Caption := '    :';
   fEdNPr := TEdit(CreateControl(TEdit, fPanel, '',
                           180,106,40,18));
   fEdNPr.AutoSize := False;
   fEdNPr.Text := '10';
   // ----------------------------------------------
   //    
   Randomize;
end;
// ----------------------------------------------------------------
//   
procedure TSensor.Free;
begin
  // ---------------
  fLbIndx.Free;
  fLbTitle.Free;
  fSTxtIndx.Free;
  fEdTitle.Free;
  // ---------------
  fLbMin.Free;
  fLbValue.Free;
  fLbMax.Free;
  fEdMin.Free;
  fSTxtValue.Free;
  fEdMax.Free;
  // ---------------
  fTrackBar.Free;
  // ---------------
  fChBoxNPr.Free;
  fEdNPr.Free;
  // ---------------
  fPanel.Free;
  // ---------------
  inherited Free;
end;

// ================================================================
//       
// ================================================================
// ----------------------------------------------------------------
//    
procedure TSensor.EdMinChange(Sender: TObject);
var Value : integer;
begin
  if TryEditToInt(fEdMin, Value)
  then fTrackBar.Min := Value;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.EdMaxChange(Sender: TObject);
var Value : integer;
begin
  if TryEditToInt(fEdMax, Value)
  then fTrackBar.Max := Value;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.TrackBarChange(Sender: TObject);
begin
  fSTxtValue.Caption := IntToStr(fTrackBar.Position);
end;

// ================================================================
//    
// ================================================================
// ----------------------------------------------------------------
//    (    )
procedure TSensor.SetIndx(Indx : integer);
begin
  fSTxtIndx.Tag := Indx;
  fSTxtIndx.Caption := IntToStr(Indx);
end;
// ----------------------------------------------------------------
//    (    )
function TSensor.GetIndx() : integer;
begin
  Result := fSTxtIndx.Tag;
end;
// ----------------------------------------------------------------
//   
procedure TSensor.SetTitle(Title : string);
begin
  fEdTitle.Text := Title;
end;
// ----------------------------------------------------------------
//   
function TSensor.GetTitle() : string;
begin
   Result := fEdTitle.Text;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.SetMin(Min : integer);
begin
  if Min < fTrackBar.Max
  then begin
     fEdMin.Enabled := False;
     fTrackBar.Min := Min;
     fTrackBar.Position := fTrackBar.Min
                         + (fTrackBar.Max - fTrackBar.Min) div 2;
     fEdMin.Text := IntToStr(Min);
     fEdMin.Enabled := True;
  end;
end;
// ----------------------------------------------------------------
//    
function  TSensor.GetMin() : integer;
begin
   Result := fTrackBar.Min;
end;
// ----------------------------------------------------------------
//    
procedure TSensor.SetMax(Max : integer);
begin
  if Max > fTrackBar.Min
  then begin
     fEdMax.Enabled := False;
     fTrackBar.Max := Max;
     fTrackBar.Position := fTrackBar.Min
                         + (fTrackBar.Max - fTrackBar.Min) div 2;
     fEdMax.Text := IntToStr(Max);
     fEdMax.Enabled := True;
  end;
end;
// ----------------------------------------------------------------
//    
function  TSensor.GetMax() : integer;
begin
   Result := fTrackBar.Max;
end;
// ----------------------------------------------------------------
//    
function  TSensor.GetValue() : integer;
var Value : integer;
begin
   Result := fTrackBar.Position;
   if fChBoxNPr.Checked
   then begin
     if TryEditToInt(fEdNPr, Value)
     then Result := Result + Value - 2 * Round(Value * Random);
   end;
end;
// ================================================================
//   
// ================================================================
end.

